//
//  VarlibMutator.h
//  GSFontTools
//
//  Created by Simon Cozens on 24/05/2019.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GSFontTools/FTPointArray.h>
#import <GSFontTools/GXTupleVariation.h>
#import <GSFontTools/TTFont.h>
#import <GSFontTools/table__a_v_a_r.h>
#import <GSFontTools/table__f_v_a_r.h>
#import <GSFontTools/table__g_l_y_f.h>
#import <GSFontTools/table__g_v_a_r.h>

@class OTOrderedDictionary;

NS_ASSUME_NONNULL_BEGIN

@interface GSIndexedFloatList : NSObject

- (instancetype)initWithCount:(NSUInteger)count;

- (CGFloat)floatAtIndex:(NSUInteger)index;

- (void)setFloat:(CGFloat)value atIndex:(NSUInteger)index;

@end

@interface VarlibMutator : NSObject

+ (NSDictionary *)normalizeLocation:(NSDictionary *)location forFont:(TTFont *)font;
+ (NSDictionary *)locationToUserSpace:(NSDictionary *)location forFont:(TTFont *)font;
+ (CGFloat)valueToUserSpace:(CGFloat)value axis:(GXAxis *)axis;
+ (CGFloat)linearNormalizeValue:(CGFloat)userValue axis:(GXAxis *)axis;
+ (CGFloat)applyAvarNormalization:(CGFloat)value mappings:(NSDictionary *)mappings;
+ (CGFloat)supportScalarForLocation:(NSDictionary *)location withSupport:(NSDictionary *)support;

+ (FTPointArray *)interpolateGlyph:(Glyph_g_l_y_f *)glyph
			  atNormalizedLocation:(NSDictionary *)location
					withVariations:(NSArray *)variations
							 width:(inout nullable CGFloat *)width;

+ (FTPointArray *)interpolateCoords:(FTPointArray *)origCoords
				   endPtsOfContours:(GSIntArray *)endPtsOfContours
			   atNormalizedLocation:(NSDictionary *)location
					 withVariations:(NSArray *)variations
							  width:(inout nullable CGFloat *)width;

- (instancetype)initWithOriginId:(NSString *)originId axesIds:(NSArray<NSString *> *)axesIds;

- (void)coordinatesToLayer:(out OTOrderedDictionary *_Nullable*_Nonnull)coordinatesToLayer freeMasters:(out OTOrderedDictionary *_Nullable*_Nullable)freeMasters masterIDs:(NSArray *)masterIDs originValues:(CGFloat *)originValues axisLocationCallBack:(BOOL (^)(NSString *masterId, CGFloat *axesValues))callback;

- (NSDictionary *)buildRegions:(NSArray *)masterIDs coordinatesToLayer:(OTOrderedDictionary *)coordinatesToLayer freeMasters:(OTOrderedDictionary *)freeMasters layerToFactors:(out NSMutableDictionary<NSString *, GSIndexedFloatList *> *)layerToFactors axesValueSteps:(NSDictionary *)axesSteps originValues:(CGFloat *)originValues;

- (NSMutableDictionary *)normalAxesValues:(OTOrderedDictionary *)coordinatesToLayer axesValueSteps:(NSDictionary *)axesSteps originValues:(CGFloat *)originValues;

- (OTOrderedDictionary *)coordinatesToId:(NSArray *)masterIDs originValues:(CGFloat *)originValues axisLocationCallBack:(BOOL (^)(NSString *masterId, CGFloat *axesValues))callback NS_RETURNS_RETAINED;

@end

NS_ASSUME_NONNULL_END
